/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.console;

import filenet.sim.apps.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.IVWSIMConsoleActionListener;
import filenet.sim.toolkit.console.IVWSIMConsoleStatusListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleActionEvent;
import filenet.sim.toolkit.console.VWSIMConsoleStatusEvent;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class VWSIMConsoleToolBar
extends JToolBar
implements IVWSIMConsoleActionListener,
IVWSIMConsoleStatusListener {
    protected ActionListener m_listener = null;
    public JButton m_actionButton = null;
    public JButton m_viewButton = null;
    public AbstractButton m_newScenarioButton = null;
    public AbstractButton m_openScenarioButton = null;
    public AbstractButton m_startSimulationButton = null;
    public AbstractButton m_stopSimulationButton = null;
    public AbstractButton m_viewAnimation = null;
    public AbstractButton m_deleteButton = null;
    public AbstractButton m_refreshButton = null;
    public AbstractButton m_propertyButton = null;
    public AbstractButton m_upButton = null;
    public AbstractButton m_helpButton = null;

    public VWSIMConsoleToolBar(ActionListener listener) {
        try {
            this.m_listener = listener;
            this.setFloatable(false);
            this.setBorderPainted(false);
            this.createButtons();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void createButtons() {
        try {
            this.addSeparator();
            this.m_newScenarioButton = VWSIMImageLoader.createToolBarButton("new.gif", VWSIMResource.NewScenario, false);
            this.add(this.m_newScenarioButton);
            this.m_newScenarioButton.addActionListener(this.m_listener);
            this.m_newScenarioButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_NEW_SCENARIO);
            this.m_newScenarioButton.setEnabled(true);
            this.m_newScenarioButton.setRolloverEnabled(true);
            this.m_openScenarioButton = VWSIMImageLoader.createToolBarButton("open_scenario.gif", VWSIMResource.OpenScenario, false);
            this.add(this.m_openScenarioButton);
            this.m_openScenarioButton.addActionListener(this.m_listener);
            this.m_openScenarioButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_OPEN_SCENARIO);
            this.m_openScenarioButton.setEnabled(false);
            this.m_openScenarioButton.setRolloverEnabled(true);
            VWSIMImageLoader.addToolbarSeparator(this);
            this.m_startSimulationButton = VWSIMImageLoader.createToolBarButton("go.gif", VWSIMResource.StartSimulation, false);
            this.add(this.m_startSimulationButton);
            this.m_startSimulationButton.addActionListener(this.m_listener);
            this.m_startSimulationButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_RUN_SIMULATION);
            this.m_startSimulationButton.setEnabled(false);
            this.m_startSimulationButton.setRolloverEnabled(true);
            this.m_stopSimulationButton = VWSIMImageLoader.createToolBarButton("stop.gif", VWSIMResource.StopSimulation, false);
            this.add(this.m_stopSimulationButton);
            this.m_stopSimulationButton.addActionListener(this.m_listener);
            this.m_stopSimulationButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_STOP_SIMULATION);
            this.m_stopSimulationButton.setEnabled(false);
            this.m_stopSimulationButton.setRolloverEnabled(true);
            this.m_viewAnimation = VWSIMImageLoader.createToolBarButton("vAnimation.gif", VWSIMResource.ViewAnimation, false);
            this.add(this.m_viewAnimation);
            this.m_viewAnimation.addActionListener(this.m_listener);
            this.m_viewAnimation.setActionCommand(VWSIMConsoleActionCommand.ACMD_VIEW_ANIMATION);
            this.m_viewAnimation.setEnabled(false);
            this.m_viewAnimation.setRolloverEnabled(true);
            VWSIMImageLoader.addToolbarSeparator(this);
            this.m_propertyButton = VWSIMImageLoader.createToolBarButton("properties.gif", VWSIMResource.Properties, false);
            this.add(this.m_propertyButton);
            this.m_propertyButton.addActionListener(this.m_listener);
            this.m_propertyButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_PROPERTIES);
            this.m_propertyButton.setEnabled(false);
            this.m_propertyButton.setRolloverEnabled(true);
            this.m_refreshButton = VWSIMImageLoader.createToolBarButton("refresh.gif", VWSIMResource.Refresh, false);
            this.add(this.m_refreshButton);
            this.m_refreshButton.addActionListener(this.m_listener);
            this.m_refreshButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_REFRESH);
            this.m_refreshButton.setEnabled(true);
            this.m_refreshButton.setRolloverEnabled(true);
            this.m_deleteButton = VWSIMImageLoader.createToolBarButton("delete.gif", VWSIMResource.Delete, false);
            this.add(this.m_deleteButton);
            this.m_deleteButton.addActionListener(this.m_listener);
            this.m_deleteButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_DELETE);
            this.m_deleteButton.setEnabled(false);
            this.m_deleteButton.setRolloverEnabled(true);
            this.m_upButton = VWSIMImageLoader.createToolBarButton("up.gif", VWSIMResource.Up, false);
            this.add(this.m_upButton);
            this.m_upButton.addActionListener(this.m_listener);
            this.m_upButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_UP);
            this.m_upButton.setEnabled(true);
            this.m_upButton.setRolloverEnabled(true);
            VWSIMImageLoader.addToolbarSeparator(this);
            this.m_helpButton = VWSIMImageLoader.createToolBarButton("help.gif", VWSIMResource.HelpTopics, false);
            this.add(this.m_helpButton);
            this.m_helpButton.addActionListener(this.m_listener);
            this.m_helpButton.setActionCommand(VWSIMConsoleActionCommand.ACMD_HELP_TOPICS);
            this.m_helpButton.setEnabled(true);
            this.m_helpButton.setRolloverEnabled(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setToolBar(VWSIMBaseNode bNode) {
        int nodeType = bNode.getType();
        switch (nodeType) {
            case 17: {
                this.m_openScenarioButton.setEnabled(false);
                this.m_startSimulationButton.setEnabled(false);
                this.m_stopSimulationButton.setEnabled(false);
                this.m_propertyButton.setEnabled(false);
                this.m_refreshButton.setEnabled(false);
                this.m_deleteButton.setEnabled(false);
                this.m_viewAnimation.setEnabled(false);
                this.m_upButton.setEnabled(false);
                break;
            }
            case 16: 
            case 18: {
                this.m_openScenarioButton.setEnabled(false);
                this.m_startSimulationButton.setEnabled(false);
                this.m_stopSimulationButton.setEnabled(false);
                if (bNode.getIdmItem() != null) {
                    this.m_propertyButton.setEnabled(true);
                } else {
                    this.m_propertyButton.setEnabled(false);
                }
                this.m_refreshButton.setEnabled(true);
                this.m_deleteButton.setEnabled(false);
                this.m_viewAnimation.setEnabled(false);
                this.m_upButton.setEnabled(true);
                break;
            }
            case 33: {
                VWSIMScenarioNode scnNode = (VWSIMScenarioNode)bNode;
                if (scnNode.canViewContent()) {
                    this.m_startSimulationButton.setEnabled(true);
                    this.m_openScenarioButton.setEnabled(true);
                } else {
                    this.m_startSimulationButton.setEnabled(false);
                    this.m_openScenarioButton.setEnabled(false);
                }
                this.m_stopSimulationButton.setEnabled(false);
                if (bNode.getIdmItem() != null) {
                    this.m_propertyButton.setEnabled(true);
                } else {
                    this.m_propertyButton.setEnabled(false);
                }
                this.m_refreshButton.setEnabled(true);
                this.m_deleteButton.setEnabled(true);
                this.m_viewAnimation.setEnabled(false);
                this.m_upButton.setEnabled(false);
                break;
            }
            case 34: {
                VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)bNode;
                this.m_startSimulationButton.setEnabled(false);
                if (aSimNode.canViewContent()) {
                    this.m_viewAnimation.setEnabled(true);
                    this.m_openScenarioButton.setEnabled(true);
                } else {
                    this.m_viewAnimation.setEnabled(false);
                    this.m_openScenarioButton.setEnabled(false);
                }
                if (aSimNode.getStatus() == 1) {
                    this.m_stopSimulationButton.setEnabled(true);
                } else {
                    this.m_stopSimulationButton.setEnabled(false);
                }
                if (bNode.getIdmItem() != null) {
                    this.m_propertyButton.setEnabled(true);
                } else {
                    this.m_propertyButton.setEnabled(false);
                }
                this.m_refreshButton.setEnabled(true);
                this.m_deleteButton.setEnabled(true);
                this.m_upButton.setEnabled(false);
            }
        }
    }

    public void consoleActionPerformed(VWSIMConsoleActionEvent evt) {
        VWSIMBaseNode aNode = evt.getBaseNode();
        if (evt.setFocus()) {
            if (aNode.getParent() != null) {
                this.m_upButton.setEnabled(true);
                this.m_upButton.setRolloverEnabled(true);
            } else {
                this.m_upButton.setEnabled(false);
            }
            this.setToolBar(aNode);
        } else if (evt.updateToolbarMenubar()) {
            this.setToolBar(aNode);
        }
    }

    public void consoleStatusChanged(VWSIMConsoleStatusEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        try {
            int statusType = evt.getType();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseResources() {
        if (this.m_listener == null) {
            return;
        }
        if (this.m_actionButton != null) {
            this.m_actionButton.removeActionListener(this.m_listener);
            this.m_actionButton = null;
        }
        if (this.m_viewButton != null) {
            this.m_viewButton.removeActionListener(this.m_listener);
            this.m_viewButton = null;
        }
        if (this.m_newScenarioButton != null) {
            this.m_newScenarioButton.removeActionListener(this.m_listener);
            this.m_newScenarioButton = null;
        }
        if (this.m_openScenarioButton != null) {
            this.m_openScenarioButton.removeActionListener(this.m_listener);
            this.m_openScenarioButton = null;
        }
        if (this.m_startSimulationButton != null) {
            this.m_startSimulationButton.removeActionListener(this.m_listener);
            this.m_startSimulationButton = null;
        }
        if (this.m_stopSimulationButton != null) {
            this.m_stopSimulationButton.removeActionListener(this.m_listener);
            this.m_stopSimulationButton = null;
        }
        if (this.m_viewAnimation != null) {
            this.m_viewAnimation.removeActionListener(this.m_listener);
            this.m_viewAnimation = null;
        }
        if (this.m_deleteButton != null) {
            this.m_deleteButton.removeActionListener(this.m_listener);
            this.m_deleteButton = null;
        }
        if (this.m_refreshButton != null) {
            this.m_refreshButton.removeActionListener(this.m_listener);
            this.m_refreshButton = null;
        }
        if (this.m_propertyButton != null) {
            this.m_propertyButton.removeActionListener(this.m_listener);
            this.m_propertyButton = null;
        }
        if (this.m_upButton != null) {
            this.m_upButton.removeActionListener(this.m_listener);
            this.m_upButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_listener);
            this.m_helpButton = null;
        }
        this.m_listener = null;
        this.removeAll();
    }
}

